<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>NCDC | System Login</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <style>
        :root {
            --ncdc-green: #0A5C36;
            --ncdc-green-dark: #074729;
            --bg-app: #F4F7F9;
            --text-primary: #1E293B;
            --text-secondary: #64748B;
            --border-light: #E2E8F0;
        }

        body {
            margin: 0; padding: 0; box-sizing: border-box;
            font-family: 'Inter', sans-serif; background-color: var(--bg-app);
            display: flex; justify-content: center; align-items: center;
            height: 100vh; color: var(--text-primary);
        }

        .login-wrapper {
            background: #FFFFFF; width: 100%; max-width: 400px;
            border-radius: 12px; box-shadow: 0 10px 25px rgba(0,0,0,0.05);
            overflow: hidden; border-top: 5px solid var(--ncdc-green);
        }

        .login-header { padding: 30px 30px 10px; text-align: center; }
        .login-header i { font-size: 40px; color: var(--ncdc-green); margin-bottom: 15px; }
        .login-header h2 { margin: 0 0 5px; font-size: 20px; font-weight: 700; }
        .login-header p { margin: 0; font-size: 13px; color: var(--text-secondary); }

        .login-body { padding: 30px; }

        .input-group { margin-bottom: 20px; }
        .input-group label { display: block; font-size: 12px; font-weight: 600; margin-bottom: 8px; color: var(--text-secondary); text-transform: uppercase; }
        .input-group input {
            width: 100%; padding: 12px 15px; border: 1px solid var(--border-light);
            border-radius: 8px; font-size: 14px; outline: none; transition: 0.2s; box-sizing: border-box;
        }
        .input-group input:focus { border-color: var(--ncdc-green); box-shadow: 0 0 0 3px rgba(10, 92, 54, 0.1); }

        .btn-primary {
            width: 100%; padding: 14px; background: var(--ncdc-green);
            color: white; border: none; border-radius: 8px; font-size: 14px;
            font-weight: 600; cursor: pointer; transition: 0.2s;
        }
        .btn-primary:hover { background: var(--ncdc-green-dark); }

        .alert-box { padding: 12px; border-radius: 6px; font-size: 13px; margin-bottom: 20px; display: none; font-weight: 500; background: #FEF2F2; color: #DC2626; border: 1px solid #FCA5A5; }
    </style>
</head>
<body>

    <div class="login-wrapper">
        <div class="login-header">
            <i class="fas fa-shield-alt"></i>
            <h2>NCDC Intelligence Hub</h2>
            <p>Authorized Personnel Only</p>
        </div>

        <div class="login-body">
            <div id="alertBox" class="alert-box"></div>

            <form id="loginForm">
                <div class="input-group">
                    <label>Official Email</label>
                    <input type="email" id="email" name="email" placeholder="name@ncdc.go.ug" required>
                </div>
                <div class="input-group">
                    <label>Password</label>
                    <input type="password" id="password" name="password" placeholder="••••••••" required>
                </div>
                <button type="submit" class="btn-primary" id="btnLogin">Access Dashboard</button>
            </form>
        </div>
    </div>

    <script>
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const btn = document.getElementById('btnLogin');
            const alertBox = document.getElementById('alertBox');
            
            btn.textContent = 'Authenticating...';
            btn.disabled = true;

            const formData = new FormData(this);

            fetch('login_action.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    window.location.href = data.redirect; 
                } else {
                    btn.textContent = 'Access Dashboard';
                    btn.disabled = false;
                    alertBox.textContent = data.message;
                    alertBox.style.display = 'block';
                }
            })
            .catch(error => {
                btn.textContent = 'Access Dashboard';
                btn.disabled = false;
                alertBox.textContent = 'System connection error.';
                alertBox.style.display = 'block';
            });
        });
    </script>
</body>
</html>